#
# This script contains procedures used by the AVD conversion program, that
# converts files downloaded from MS Exchange Server into a format readable
# by the AltaVista Directory (AVD) load applet.
#


#
# Turns a line of comma separated elements into a list
#
proc make_list_comma input {
	set check 1
	while {$check == 1} {
        set check [regsub "," $input "\} \{" input]
	}
	set input \{$input\}
	return $input
}



#
# The first part of the address can contain several newlines. We can
# only allow one of these to go through otherwise we exceed the amount
# that AVD allows when we add the other four parts. This procedure
# allows the first newline through and converts the rest into spaces
#
proc sort_out_newline input {

	global outfile

	regsub -all : $input " " input
	set input [remove_brace $input]

	set elcount 0
	set overflow 0
	set nfound 0
	set newadd1 ""

	#
	# while we have more elements (strings) in the list
	#
	while {$elcount < [llength $input]} {
		#
		# extract each element in turn from the list
		#
		set liselem [lindex $input $elcount]

		set strlen [string length $liselem]
		set lastchar [expr {$strlen - 1}]
		set strcount 0
		set nliselem ""

		if {$strlen > 60} {
			# ie it is more than two lines of thirty chars
			puts $outfile ""
			puts $outfile "# PostalAddress too long - max 6 lines of no more than 30 chars, $ is newline"
		}

		#
		# while we have more characters in the string extracted from the list
		#
		while {$strcount < $strlen} {
			set charval [string index $liselem $strcount]

			set matchn [string compare $charval \n]

			if {$matchn == 0} {
				#
				# if we have a \n (newline) we can let the first newline
				# through as we can have six lines for the address, and
				# we have five values to make the address. If we already
				# have let one \n through we append a space instead.
				#
				# A newline is denoted in AHS (addresses) as a $ sign.
				#
				if {$nfound == 1} {
					append nliselem " "
					incr overflow
				} elseif {$lastchar != $strcount} {
					if {$overflow > 30} {
						puts $outfile ""
						puts $outfile "# first line of PostalAddress too long -  more than 30 chars"
					} else {
						set overflow 0
					}
					append nliselem "$"
				}
				set nfound 1
			} else {
				# No special processing needed, so just append the char
				append nliselem $charval
				incr overflow
			}
			incr strcount
		}
		#
		# Need to increment for spaces too
		#
		incr overflow
		if {$overflow > 30} {
			if {$nfound == 1} {
				puts $outfile ""
				puts $outfile "# second line of PostalAddress too long - more than 30 chars"
			} else {
				puts $outfile ""
				puts $outfile "# first line of PostalAddress too long - more than 30 chars"
			}
		}
		append newadd1 $nliselem
		append newadd1 " "
		incr elcount
	}
	flush $outfile
	return $newadd1
}





#
# procedure that turns commas into a close brace, a space and an
# open brace unless it is inside quotes in which case we leave it alone.
# We also remove \r chars that AHS doesn't recognise. If the previous
# char to \r was a comma, we remove the \r, if the previous char wasn't
# a comma, we convert the \r into a comma.
# Also check for an even number of double quotes (i.e. matching pairs)
#
# BUG in tcl, don't write braces in comments, they get interpreted!
#
proc make_input_list input {

	global outfile

	set iterate 0
	set ilen [string length $input]
	set flag 0
	set nestflag 0
	set comflag 0
	set newline ""

	while {$ilen > $iterate} {
		set achar [string index $input $iterate]

		set matchbr [string compare $achar \r]
		set matchq [string compare $achar \"]
		set matchc [string compare $achar ,]

		set nextval [expr {$iterate+1}]
		set nextchar [string index $input $nextval]

		#
		# check for a \r as two adjacent chars (i.e. a "\" and a "r")
		#
		if {[string compare $achar \\] == 0} {
			if {[string compare $nextchar r] == 0} {
				# We have matched a backslash
				set matchbr 0
				incr iterate
			}
		}
		if {($matchq == 0) && ($flag == 0)} {
			#
			# will set flag to say that we are just entering some quotes
			#
			set flag 1
			set comflag 0
		} elseif {($matchq == 0) && ($flag == 1)} {
			#
			# We are inside quotes and have found another quote
			#
			if {[string compare $nextchar \"] == 0} {
				#
				# If we are inside quotes and we find two sets of quotes, then
				# we actually have a nested set of quotes
				#
				append newline $achar
				#
				# We don't want a \n at the end of a list element, we will check for a \n
				# as either two chars or one char. This is because tcl considers the
				# following value invalid {"1, High Str.,"\n} and we can easily generate
				# this with MS Exchange Server
				#
				if {$nestflag == 0} {
					set nestflag 1
				} else {
					set nestflag 0
					incr nextval
					set nextchar [string index $input $nextval]
					if {[string compare $nextchar " "] != 0 && [string compare $nextchar \"] != 0} {
						append newline " "
					}
				}
				incr iterate
			} else {
				set flag 0
				set comflag 0
			}
		} elseif {($matchc == 0) && ($flag == 1) && ($comflag == 0)} {
			#
			# we leave each comma alone (append it to the end of newline).
			#
			append newline $achar
			set comflag 1
		} elseif {($matchc == 0) && ($flag == 0)} {
			#
			# we convert comma into a "\} \{".
			#
			append newline "\} \{"
			set comflag 0
		} elseif {($matchbr == 0) && ($comflag == 1)} {
			#
			# we convert \r into a "" (i.e. nothing).
			#
			set comflag 0
		} elseif {($matchbr == 0) && ($comflag ==0)} {
			#
			# we convert \r into a ",".
			#
			append newline ","
			set comflag 1
		} else {
			#
			# i.e. not a comma or a quote, so just append it to the line
			#
			append newline $achar
			set comflag 0
		}
		incr iterate
	}
	if {$flag == 1} {
		puts $outfile ""
		puts $outfile "# Line does not having matching double quotes"
	}
	set input \{$newline\}
	return $input
}



#
# this procedure takes the mail string produced by MS Exchange Server
# and chops off the spurious chars at the beginning and the end to
# produce an SMTP address.
#
proc get_mail_val input {

	global outfile

	#
	# Having been written by MS Exchange, we are expecting there to be
	# a valid SMTP mail address
	#
	set mailbox $input
	set startpos [string first %SMTP: $mailbox]
	if {$startpos == -1} {
		puts $outfile ""
    	puts $outfile "# Not an SMTP mailbox"
		set input \t
		return $input
	} else {
		#
		# need to jump over "%SMTP:" so add 6 to startpos.
		#
		incr startpos 6
		set mailbox [string range $mailbox $startpos end]
		set endpos [string first % $mailbox]
		if {$endpos == -1} {
			set endpos [string length $mailbox]
		}
		#
		# As we start from char 0 we need to subtract 1 from endpos.
		#
		incr endpos -1
		set mailbox [string range $mailbox 0 $endpos]
		if {[string length $mailbox] <= 0} {
			puts $outfile ""
			puts $outfile "# Not an SMTP mailbox"
			set input \t
			return $input
		}
		set mailbox \{$mailbox\}
		set input $mailbox\t
	}
	return $input
}





# This procedure removes all the braces from input
proc remove_brace input {
	set check 1
	while {$check == 1} {
        set check [regsub "\} \{" $input "" input]
	}
	regsub -all \{ $input "" input
	regsub -all \} $input "" input
	return $input
}


# This procedure converts spaces into tabs
proc space_to_tab input {
	set check 1
	while {$check == 1} {
        set check [regsub " " $input "\t" input]
	}
	regsub -all \{ $input "" input
	regsub -all \} $input "" input
	return $input
}

